/*
 * Decompiled with CFR 0.152.
 */
package com.redpxnda.respawnobelisks.config;

import com.redpxnda.respawnobelisks.config.ChargeConfig;
import com.redpxnda.respawnobelisks.config.CurseConfig;
import com.redpxnda.respawnobelisks.config.ObeliskCoreConfig;
import com.redpxnda.respawnobelisks.config.RespawnPerkConfig;
import com.redpxnda.respawnobelisks.config.ReviveConfig;
import com.redpxnda.respawnobelisks.config.TeleportConfig;
import com.redpxnda.respawnobelisks.config.TrustedPlayersConfig;
import com.teamresourceful.resourcefulconfig.common.annotations.Comment;
import com.teamresourceful.resourcefulconfig.common.annotations.Config;
import com.teamresourceful.resourcefulconfig.common.annotations.ConfigEntry;
import com.teamresourceful.resourcefulconfig.common.annotations.InlineCategory;
import com.teamresourceful.resourcefulconfig.common.config.EntryType;
import com.teamresourceful.resourcefulconfig.web.annotations.WebInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

@Config(value="respawnobelisks")
@WebInfo(icon="smartphone-charging")
public final class RespawnObelisksConfig {
    private static List<Block> bannedBlocks = new ArrayList<Block>();
    @ConfigEntry(id="allowBedRespawning", type=EntryType.BOOLEAN, translation="text.respawnobelisks.config.allow_bed_respawning")
    @Comment(value="Whether players should be able to set their spawn at beds.\nThis has no effect on whether players can sleep or not. Only disallows setting spawn at beds.\nMAKE SURE TO REMOVE '#minecraft:beds' FROM 'bannedRespawnBlocks'!")
    public static boolean allowBedRespawning = false;
    @ConfigEntry(id="bannedRespawnBlocks", type=EntryType.STRING, translation="text.respawnobelisks.config.allow_bed_respawning")
    @Comment(value="A list of blocks that players cannot respawn from. This is mainly to enforce 'allowBedRespawning'.\nKeep in mind that adding modded blocks to this list will not prevent the player from 'setting' their spawn at that block.\nIt will only prevent them from spawning their when respawning.\nTags are supported. To use them, use a hashtag before the name. Eg. #minecraft:beds")
    public static String[] bannedRespawnBlocks = new String[]{"#minecraft:beds"};
    @InlineCategory
    public static CurseConfig curseConfig;
    @InlineCategory
    public static ChargeConfig chargeConfig;
    @InlineCategory
    public static TeleportConfig teleportConfig;
    @InlineCategory
    public static ReviveConfig reviveConfig;
    @InlineCategory
    public static TrustedPlayersConfig trustedPlayersConfig;
    @InlineCategory
    public static ObeliskCoreConfig obeliskCoreConfig;
    @InlineCategory
    public static RespawnPerkConfig respawnPerkConfig;

    public static boolean isBlockBanned(BlockState block) {
        if (bannedBlocks.isEmpty()) {
            for (String str : bannedRespawnBlocks) {
                ResourceLocation loc;
                if (str.startsWith("#")) {
                    TagKey tag;
                    loc = ResourceLocation.m_135820_((String)(str = str.substring(1)));
                    if (loc == null || !Registry.f_122824_.m_203431_(tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)loc)).isPresent()) continue;
                    for (Holder blockHolder : (HolderSet.Named)Registry.f_122824_.m_203431_(tag).get()) {
                        bannedBlocks.add((Block)blockHolder.m_203334_());
                    }
                    continue;
                }
                loc = ResourceLocation.m_135820_((String)str);
                if (loc == null) continue;
                Registry.f_122824_.m_6612_(loc).ifPresent(b -> bannedBlocks.add((Block)b));
            }
        }
        return bannedBlocks.contains(block.m_60734_());
    }
}

